unit DBTree;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, ComCtrls, DB, FireDAC.Comp.Client;

Type
  PNodeInfo = ^TNodeInfo;
  TNodeInfo = Packed Record
     ID    : Integer;
     PID   : Integer;
     Caption  : String;
   end;

//
//MemTable:ڴ; TableName: Ӧı; TreeView: ʹõ
procedure MakeTree(MemTable: TFDQuery; TreeView: TTreeView);



//Ľڵ
//MemTable:ڴ;TreeView: ʹõ
function AddNode(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;

//ӽڵ
//MemTable:ڴ;TreeView: ʹõ
function AddChildNode(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;

//ӽڵ㣨ڲʹõḶ́
//MemTable:ڴ;TreeView: ʹõ;bj:Ƿ񽫽ƵǰѡĽڵ
function AddTreeNode(MemTable: TFDQuery; TreeView: TTreeView; bj: boolean = false):TTreeNode;

//ɾڵ㣨ɾڵµӽڵ㣩
//MemTable:ڴ;TreeView: ʹõ
procedure DelTree(MemTable: TFDQuery; TreeView: TTreeView);

//ݿеαѾƶƵжӦĽڵ
//MemTable:ڴ;TreeView: ʹõ
function TreeSelect(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;

function MakeGroup(MemTable: TFDQuery; TreeView: TTreeView; pGroupName, GroupName:string):TTreeNode;

//ҳݣƶݿеα꣬ͬʱƵжӦĽڵ
//TreeView: ʹõ text: Ҫҵ
function TreeFind(TreeView: TTreeView; text: string): TTreeNode; overload;

function TreeFind(TreeNode:TTreeNode; text: string): TTreeNode; overload;

function TreeFindByID(TreeView: TTreeView; ID: Integer): TTreeNode;

var
  ANodeInfo : PNodeInfo;
implementation

procedure MakeTree(MemTable: TFDQuery; TreeView: TTreeView);
begin
  TreeView.Items.BeginUpdate;
  TreeView.items.clear;
  MemTable.DisableControls;

  MemTable.First;
  while not MemTable.Eof do
  begin
    AddTreeNode(MemTable, TreeView); //еĽڵ
    MemTable.Next;
  end;
  TreeView.AlphaSort(); //
  TreeView.Items.EndUpdate;
  MemTable.EnableControls;
  if treeview.Items.Count < 1 then exit;
  treeview.Select(treeview.Items.Item[0]);
  treeview.FullExpand;
end;

function AddTreeNode(MemTable: TFDQuery; TreeView: TTreeView; bj: boolean = false):TTreeNode;
var
  Node: TTreeNode;
begin
  try
    New(ANodeInfo);
    ANodeInfo^.ID:=MemTable.FieldByName('ID').AsInteger;
    ANodeInfo^.PID:=MemTable.FieldByName('PID').AsInteger;
    ANodeInfo^.Caption:=MemTable.FieldByName('Caption').AsString;

    if MemTable.FieldByName('PID').AsInteger = 0 then { ParentID=0ڵ }
      Node := TreeView.Items.AddChildObject(nil, MemTable.FieldByName('CAPTION').AsString, ANodeInfo)
    else
    begin
      //ҵǰڵĸ
      Node:=TreeFindByID(TreeView,MemTable.FieldByName('PID').AsInteger);
      Node := TreeView.Items.AddChildObject(Node, MemTable.FieldByName('CAPTION').AsString, ANodeInfo);
      //ӽڵ㣬ڵӦļ¼ǩݷŵڵṩĸ
    end;
    Result:=Node;

    if bj then
    begin
      treeview.Select(node);
      treeview.SetFocus;
    end;
  finally
//    Dispose(ANodeInfo);
  end;
end;

procedure DelTree(MemTable: TFDQuery; TreeView: TTreeView);
var
  node: TTreenode;
//ɾǰѡĽڵµнڵ㣨ɾǰѡĽڵ㣩
  procedure DelNode(node: TTreenode);
  var
    i: integer;
    childnode: TTreenode;
  begin
    for i := 0 to node.Count - 1 do
    begin
      childnode := node.Item[i]; //ȡǰڵµнڵ
      MemTable.Locate('id',PNodeInfo(childnode.Data)^.ID,[]);
      MemTable.Delete; //ɾӦļ¼
      if node.HasChildren then DelNode(childnode); //ӽڵݹֱеɾ
    end;
  end;
{һ
һݹ飺
procedure doSearch(tn: TTreeNode);
var i: ingeger;
begin
if tn.HasChildren then
begin
for i := tn.Count -1 downto 0 do doSearch(tn[i]);
end
else
begin
//ÿڵҪ
end;
end;}

begin
  node := treeview.Selected;
  if node = nil then exit;
  //ɾǰѡĽڵµнڵ㣨ɾǰѡĽڵ㣩
  DelNode(node);
  //ɾǰѡĽڵ
  if not MemTable.Locate('id',PNodeInfo(node.Data)^.ID,[]) then
  begin
    //ɾʧ
    Exit;
  end;
  MemTable.Delete;
  node.Delete;
  TreeView.SetFocus;
end;

function AddChildNode(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;
var
  id: integer;
begin
  id := MemTable.FieldByName('ID').AsInteger; //µǰĽڵ
  MemTable.Append;
  MemTable.FieldByName('PID').AsInteger := id; //ӵӽڵĸڵżΪid
  MemTable.FieldByName('Caption').AsString := 'ӽڵ';
  MemTable.post;
  Result:=AddTreeNode(MemTable, TreeView, true);
end;

function AddNode(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;
var
  pid: integer;
begin
  pid := MemTable.FieldByName('PID').AsInteger; //µǰڵĸڵ
  MemTable.Append;
  MemTable.FieldByName('PID').AsInteger := pid; //ӵӽڵĸڵżΪpid
  MemTable.FieldByName('caption').AsString := '½ڵ';
  MemTable.post;
  Result:=AddTreeNode(MemTable, TreeView, true);
end;

function TreeSelect(MemTable: TFDQuery; TreeView: TTreeView):TTreeNode;
var
  Node: TTreeNode;
begin
  Result:=nil;
  Node := TreeFindByID(TreeView,MemTable.FieldByName('ID').AsInteger);
  if Node<>nil then
  begin
    Result:=Node;
    treeview.Selected := Node;
    treeview.SetFocus;
  end;
end;

function TreeFind(TreeView: TTreeView; text: string): TTreeNode;
var
  i: integer;
begin
  Result:=nil;
  for i := 0 to treeview.Items.Count - 1 do
  begin
    if treeview.Items.Item[i].Text = text then
    begin
      Result:=treeview.Items.Item[i];
      exit;
    end;
  end;
end;

function TreeFindByID(TreeView: TTreeView; ID: Integer): TTreeNode;
var
  i:integer;
begin
  Result:=nil;
  for i := 0 to treeview.Items.Count - 1 do
  begin
    if PNodeInfo(treeview.Items[i].Data)^.ID = ID then
    begin
      Result:= treeview.Items[i];
      exit;
    end;
  end;
end;

function TreeFind(TreeNode:TTreeNode; text: string): TTreeNode;//ĳڵõеӽڵ
var
  vNode:TTreeNode;
begin
  Result:=nil;
  vNode:=TreeNode.getFirstChild;
  While vNode<>nil do
  begin
    if vNode.Text=text then
    begin
      Result:=vNode;
      Break;
    end
    else
      vNode:=TreeNode.GetNextChild(vNode);
  end;
end;

function MakeGroup(MemTable: TFDQuery; TreeView: TTreeView; pGroupName, GroupName:string):TTreeNode;
var
  pTreeNode,aTreeNode:TTreeNode;
begin
  //Ĭϵڸ
  pTreeNode:=TreeView.Items.GetFirstNode;
  //ȡϼڵ
  if pGroupName<>'' then
  begin
    aTreeNode:=TreeFind(TreeView,pGroupName);
    if aTreeNode<>nil then pTreeNode:=aTreeNode; //ҵϼڵ
  end;
  //ҵڵ
  if GroupName<>'' then
  begin
    aTreeNode:=TreeFind(pTreeNode,GroupName);    //ҵϼڵ
    if aTreeNode<>nil then
    begin
      Result:=aTreeNode; //ҵڵ
      Exit;
    end;
  end;

  //ϼ鲻ڣ
  if PNodeInfo(pTreeNode.Data)^.Caption<>pGroupName then //Ŀ¼´һڵ
  begin
    MemTable.Append;
    MemTable.FieldByName('PID').AsInteger := 1;
    MemTable.FieldByName('caption').AsString := pGroupName;
    MemTable.post;
    pTreeNode:=AddTreeNode(MemTable, TreeView, true);
  end;

  MemTable.Append;
  MemTable.FieldByName('PID').AsInteger := PNodeInfo(pTreeNode.Data)^.ID;
  MemTable.FieldByName('caption').AsString := GroupName;
  MemTable.post;
  Result:=AddTreeNode(MemTable, TreeView, true);
end;

end.

